import shutil
from distutils.core import setup

from Cython.Build import cythonize

setup(name='face_detection_and_recognition_2',
      ext_modules=cythonize('face_detect/face_detection_and_recognition_2.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'face_detect',
              'build_temp': 'build'
          }
      })

setup(name='face_detection_and_recognition_3',
      ext_modules=cythonize('face_detect/face_detection_and_recognition_3.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'face_detect',
              'build_temp': 'build'
          }
      })

setup(name='model',
      ext_modules=cythonize('reid/model.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'reid',
              'build_temp': 'build'
          }
      })

setup(name='model_3dta',
      ext_modules=cythonize('reid/model_3dta.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'reid',
              'build_temp': 'build'
          }
      })

setup(name='output',
      ext_modules=cythonize('reid/output.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'reid',
              'build_temp': 'build'
          }
      })

setup(name='inference',
      ext_modules=cythonize('attribute_detect/inference.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'attribute_detect',
              'build_temp': 'build'
          }
      })

setup(name='yolo_detect',
      ext_modules=cythonize('yolov3/yolo_detect.py'),
      script_args=['build_ext'],
      options={
          'build_ext': {
              'build_lib': 'yolov3',
              'build_temp': 'build'
          }
      })


shutil.rmtree('build')
